﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.WinForm.Forms;
using IndianHealthService.BMXNet.WinForm.Configuration;

namespace IndianHealthService.BMXNet.Forms
{
    internal partial class RpmsLoginDialog : Form, RpmsLoginView
    {
        public RpmsLoginDialog()
        {
            InitializeComponent();
            this.connectionComboBox.DisplayMember = "Name";
        }

        private bool _isSwitchServerModeEnabled = false;

        public bool IsSwitchServerModeEnabled
        {
            get { return _isSwitchServerModeEnabled; }
            set { _isSwitchServerModeEnabled = value; }
        }

        private void txtAccess_TextChanged(object sender, EventArgs e)
        {
        }

        private void RpmsLoginDialog_Load(object sender, EventArgs e)
        {
            this.Icon = this.Owner.Icon;

            if (this.IsSwitchServerModeEnabled)
            {
                this.connectionComboBox.DroppedDown = true;
                this.connectionComboBox.Focus();
            }
            else
            {
                this.accessCodeEntry.Focus();
            }
        }

        public void ShowView(IWin32Window anOwner)
        {
            this.ShowDialog(anOwner);
        }

        public IWin32Window UiOwner
        {
            get { return this.Owner; }
        }


        #region RpmsLoginView Members

        public string Title
        {
            set { this.Text = value; }
        }

        public List<IndianHealthService.BMXNet.WinForm.Configuration.RpmsConnectionSpec> ConnectionSpecs
        {
            set
            {
                this.connectionComboBox.BeginUpdate();
                this.connectionComboBox.SelectedIndex= - 1;
                this.connectionComboBox.Items.Clear();
                foreach (RpmsConnectionSpec each in value)
                {
                    this.connectionComboBox.Items.Add(each);
                }
                this.connectionComboBox.EndUpdate();
            }
        }

        public string AccessCode
        {
            get { return this.accessCodeEntry.Text; }
        }

        public string VerifyCode
        {
            get { return this.verifyCodeEntry.Text; }
        }

        public bool UseWindowsAuthentication
        {
            get
            {
                return this.useWindowAuthCheckbox.Checked;
            }
            set
            {
                this.useWindowAuthCheckbox.Checked = value;
            }
        }

        public bool EnableUseWindowsAuthentication
        {
            get
            {
                return this.useWindowAuthCheckbox.Enabled;
            }
            set
            {
                this.useWindowAuthCheckbox.Enabled = value;
            }
        }

        public RpmsConnectionSpec ConnectionSpec
        {
            get { return (RpmsConnectionSpec)this.connectionComboBox.SelectedItem; }
            set
            {
                this.connectionComboBox.SelectedItem = value;
                if (value != null)
                {
                       
                    this.accessCodeEntry.Focus();
                }
            }
        }

        public event EventHandler Ok;

        public event EventHandler Cancel;

        public event EventHandler ConnectionSpecSelected;

        #endregion

        private void connectionComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.ConnectionSpecSelected != null)
            {
                this.ConnectionSpecSelected(this, new EventArgs());
            }
        }

    
        public void CloseView()
        {
            this.Close();
        }

        private void okButton_Click(object sender, EventArgs e)
        {
            if (this.Ok != null)
            {
                this.Ok(this, new EventArgs());
            }
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            if (this.Cancel != null)
            {
                this.Cancel(this, new EventArgs());
            }
        }

        public void ResetAccessVerifyCodes()
        {
            this.accessCodeEntry.Clear();
            this.verifyCodeEntry.Clear();
            this.accessCodeEntry.Focus();
        }

        public void ShowWait()
        {
            this.Cursor = Cursors.WaitCursor;
        }

        public void HideWait()
        {
            this.Cursor = Cursors.Default;
        }

    
    }
}
